/* Used in the following keymaps: */
/* - pc105_ru                     */
/* - pc105_by                     */

#define HAVE_UNICODE_CONVTABLE 1
#define HAVE_CHARSET_CONVTABLE 1

STATIC CONST ULONG unicodetable[] =
{
   // 0x80 - 0x8F
   0x0402, 0x0403, 0x201A, 0x0453, 0x201E, 0x2026, 0x2020, 0x2021,
   0x20AC, 0x2030, 0x0409, 0x2039, 0x040A, 0x040C, 0x040B, 0x040F,

   // 0x90 - 0x9F
   0x0452, 0x2018, 0x2019, 0x201C, 0x201D, 0x2022, 0x2013, 0x2014,
   0x0000, 0x2122, 0x0459, 0x203A, 0x045A, 0x045C, 0x045B, 0x045F,

   // 0xA0 - 0xAF
   0x00A0, 0x040E, 0x045E, 0x0408, 0x00A4, 0x0490, 0x00A6, 0x00A7,
   0x0401, 0x00A9, 0x0404, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x0407,

   // 0xB0 - 0xBF
   0x00B0, 0x00B1, 0x0406, 0x0456, 0x0491, 0x00B5, 0x00B6, 0x00B7,
   0x0451, 0x2116, 0x0454, 0x00BB, 0x0458, 0x0405, 0x0455, 0x0457,

   // 0xC0 - 0xCF
   0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417,
   0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F,

   // 0xD0 - 0xDF
   0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
   0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F,

   // 0xE0 - 0xEF
   0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
   0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F,

   // 0xF0 - 0xFF
   0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
   0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F
};


STATIC CONST struct UCS4_ConvTable convtable =
{
   0x80,
   0xff,
   unicodetable
};


STATIC CONST UBYTE chartable01[] =
{
   // 0x00A0
   0xA0
};

STATIC CONST UBYTE chartable02[] =
{
   // 0x00A4
	0xA4
};

STATIC CONST UBYTE chartable03[] =
{
   // 0x00A6 - 0x00A7
   0xA6, 0xA7
};

STATIC CONST UBYTE chartable04[] =
{
   // 0x00A9
   0xA9
};


/*
   There was a bug in chartable05[]. The mapping for Unicode range 0x00AB - 0x00B7 to
   Windows-1251 is as follows:

   00AB -> 0xAB   LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
   00AC -> 0xAC   NOT SIGN
   00AD -> 0xAD   SOFT HYPHEN
   00AE -> 0xAE   REGISTERED SIGN
   00AF -> none   MACRON
   00B0 -> 0xB0   DEGREE SIGN
   00B1 -> 0xB1   PLUS-MINUS SIGN
   00B2 -> none   SUPERSCRIPT TWO
   00B3 -> none   SUPERSCRIPT THREE
   00B4 -> none   ACUTE ACCENT
   00B5 -> 0xB5   MICRO SIGN
   00B6 -> 0xB6   PILCROW SIGN
   00B7 -> 0xB7   MIDDLE DOT

   There are three continuous Unicode ranges, so the table is splitted into 3 tables:
   05a, 05b and 05c.

   krashan, 15.11.2010
*/

STATIC CONST UBYTE chartable05a[4] =
{
	// 0x00AB - 0x00AE
	0xAB, 0xAC, 0xAD, 0xAE
};

STATIC CONST UBYTE chartable05b[2] =
{
	// 0x00B0 - 0x00B1
	0xB0, 0xB1
};

STATIC CONST UBYTE chartable05c[3] =
{
	// 0x00B5 - 0x00B7
	0xB5, 0xB6, 0xB7
};


STATIC CONST UBYTE chartable06[] =
{
   // 0x00BB
   0xBB
};

STATIC CONST UBYTE chartable07[] =
{
   // 0x0401 - 0x040C
   0xA8, 0x80, 0x81, 0xAA, 0xBD, 0xB2, 0xAF, 0xA3, 0x8A, 0x8C, 0x8E, 0x8D
};

STATIC CONST UBYTE chartable08[] =
{
   // 0x040E - 0x040F
   0xA1, 0x8F
};

STATIC CONST UBYTE chartable09[] =
{
   // 0x0410 - 0x045C
   0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
   0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
   0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
   0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
   0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,
   0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
   0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
   0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF,
   0xB8, 0x90, 0x83, 0xBA, 0xBE, 0xB3, 0xBF, 0xBC,
   0x9A, 0x9C, 0x9E, 0x9D
};

STATIC CONST UBYTE chartable10[] =
{
   // 0x045E - 0x045F
   0xA2, 0x9F
};

STATIC CONST UBYTE chartable11[] =
{
   // 0x0490 - 0x0491
   0xA5, 0xB4
};

STATIC CONST UBYTE chartable12[] =
{
   // 0x2013 - 0x2014
   0x96, 0x97
};

STATIC CONST UBYTE chartable13[] =
{
   // 0x2018 - 0x201A
   0x91, 0x92, 0x82
};

STATIC CONST UBYTE chartable14[] =
{
   // 0x201C - 0x201E
   0x93, 0x94, 0x84
};

STATIC CONST UBYTE chartable15[] =
{
   // 0x2020 - 0x2022
   0x86, 0x87, 0x95
};

STATIC CONST UBYTE chartable16[] =
{
   // 0x2026
   0x85
};

STATIC CONST UBYTE chartable17[] =
{
   // 0x2030
   0x89
};

STATIC CONST UBYTE chartable18[] =
{
   // 0x2039 - 0x203A
   0x8B, 0x9B
};

STATIC CONST UBYTE chartable19[] =
{
   // 0x20AC
   0x88
};

STATIC CONST UBYTE chartable20[] =
{
   // 0x2116
   0xB9
};

STATIC CONST UBYTE chartable21[] =
{
   // 0x2122
   0x99
};

STATIC CONST struct UCS4_CharsetConvTable convtable2 =
{
   NULL,

   {
	   { 0x0a0, 0x0a0, chartable01 },
	   { 0x0a4, 0x0a4, chartable02 },
	   { 0x0a6, 0x0a6, chartable03 },
	   { 0x0a9, 0x0a9, chartable04 },
	   { 0x0ab, 0x0ae, chartable05a },
	   { 0x0b0, 0x0b1, chartable05b },
	   { 0x0b5, 0x0b7, chartable05c },
	   { 0x0bb, 0x0bb, chartable06 },
	   { 0x401, 0x40c, chartable07 },
	   { 0x40e, 0x40f, chartable08 },
	   { 0x410, 0x45c, chartable09 },
	   { 0x45e, 0x45f, chartable10 },
	   { 0x490, 0x491, chartable11 },
	   { 0x2013, 0x2014, chartable12 },
	   { 0x2018, 0x201a, chartable13 },
	   { 0x201c, 0x201e, chartable14 },
	   { 0x2020, 0x2022, chartable15 },
	   { 0x2026, 0x2026, chartable16 },
	   { 0x2030, 0x2030, chartable17 },
	   { 0x2039, 0x203a, chartable18 },
	   { 0x20ac, 0x20ac, chartable19 },
	   { 0x2116, 0x2116, chartable20 },
	   { 0x2122, 0x2122, chartable21 },
	   { 0x000, 0x000, NULL }
   }
};
